<?php

function gregorian_to_jalali($g_year, $g_month, $g_day) {
    $g_days_in_month = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
    $j_days_in_month = [31, 31, 31, 30, 30, 30, 31, 31, 30, 30, 30, 29];

    $gy = $g_year - 1600;
    $gm = $g_month - 1;
    $gd = $g_day - 1;

    $g_day_no = 365 * $gy + intval(($gy + 3) / 4) - intval(($gy + 99) / 100) + intval(($gy + 399) / 400);
    for ($i = 0; $i < $gm; ++$i) {
        $g_day_no += $g_days_in_month[$i];
    }
    if ($gm > 1 && (($g_year % 4 == 0 && $g_year % 100 != 0) || ($g_year % 400 == 0))) {
        $g_day_no++; // Adjust for leap year
    }
    $g_day_no += $gd;

    $j_day_no = $g_day_no - 79;

    $j_np = intval($j_day_no / 12053); // 12053 days = 33 years
    $j_day_no %= 12053;

    $jy = 979 + 33 * $j_np + 4 * intval($j_day_no / 1461); // 1461 days = 4 years
    $j_day_no %= 1461;

    if ($j_day_no >= 366) {
        $jy += intval(($j_day_no - 1) / 365);
        $j_day_no = ($j_day_no - 1) % 365;
    }

    for ($i = 0; $i < 11 && $j_day_no >= $j_days_in_month[$i]; ++$i) {
        $j_day_no -= $j_days_in_month[$i];
    }
    $jm = $i + 1;
    $jd = $j_day_no + 1;

    return [$jy, $jm, $jd];
}

function convert_to_shamsi($gregorian_date) {
    // جدا کردن تاریخ و زمان از ورودی
    $date = explode(" ", $gregorian_date);
    $date_parts = explode("-", $date[0]); // تاریخ
    $time_parts = $date[1]; // زمان

    $g_year = intval($date_parts[0]);
    $g_month = intval($date_parts[1]);
    $g_day = intval($date_parts[2]);

    // تبدیل به تاریخ شمسی
    list($j_year, $j_month, $j_day) = gregorian_to_jalali($g_year, $g_month, $g_day);

    // فرمت خروجی: YYYY.MM.DD HH:MM:SS
    //return sprintf("%04d.%02d.%02d %s", $j_year, $j_month, $j_day, $time_parts);
    return sprintf("%04d.%02d.%02d", $j_year, $j_month, $j_day);
}

?>
