<?php

function gregorianToJalali($gy, $gm, $gd) {
    $g_d_m = [0, 31, ($gy % 4 == 0 && ($gy % 100 != 0 || $gy % 400 == 0)) ? 29 : 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
    $jy = ($gy <= 1600) ? 0 : 979;
    $gy -= ($gy <= 1600) ? 621 : 1600;
    $gm--;
    $gd--;
    $g_day_no = 365 * $gy + (int)(($gy + 3) / 4) - (int)(($gy + 99) / 100) + (int)(($gy + 399) / 400);
    for ($i = 0; $i < $gm; ++$i) $g_day_no += $g_d_m[$i];
    $g_day_no += $gd;
    $j_day_no = $g_day_no - 79;
    $j_np = (int)($j_day_no / 12053);
    $j_day_no %= 12053;
    $jy += 33 * $j_np + 4 * (int)($j_day_no / 1461);
    $j_day_no %= 1461;
    if ($j_day_no >= 366) {
        $jy += (int)(($j_day_no - 1) / 365);
        $j_day_no = ($j_day_no - 1) % 365;
    }
    for ($i = 0; $i < 11 && $j_day_no >= [31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, 29][$i]; ++$i)
        $j_day_no -= [31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, 29][$i];
    return [$jy, $i + 1, $j_day_no + 1];
}

function convertDateToRelativeTime($gregorianDate, $language) {
    $currentDate = new DateTime();
    $inputDate = new DateTime($gregorianDate);
    $diff = $currentDate->diff($inputDate);

    $daysDifference = (int)$diff->format('%r%a'); // اختلاف روزها
    $yearsDifference = (int)$diff->format('%r%y'); // اختلاف سال‌ها
    $monthsDifference = (int)$diff->format('%r%m'); // اختلاف ماه‌ها

    // تعیین متون برای زبان فارسی و انگلیسی
    $texts = [
        'fa' => [
            'today' => "امروز",
            'yesterday' => "دیروز",
            'daysAgo' => "روز پیش",
            'weekAgo' => "هفته پیش",
            'weeksAgo' => " هفته پیش",
            'monthAgo' => "ماه پیش",
            'monthsAgo' => " ماه پیش",
            'yearAgo' => "سال پیش",
            'yearsAgo' => " سال پیش"
        ],
        'en' => [
            'today' => "Today",
            'yesterday' => "Yesterday",
            'daysAgo' => "days ago",
            'weekAgo' => "week ago",
            'weeksAgo' => " weeks ago",
            'monthAgo' => "month ago",
            'monthsAgo' => " months ago",
            'yearAgo' => "year ago",
            'yearsAgo' => " years ago"
        ]
    ];

    $text = $texts[$language];

    if ($daysDifference === 0) {
        return $text['today'];
    } elseif ($daysDifference === -1) {
        return $text['yesterday'];
    } elseif ($daysDifference < -1 && $daysDifference > -7) {
        return abs($daysDifference) . " " . $text['daysAgo'];
    } elseif ($daysDifference <= -7 && $daysDifference > -14) {
        return "1 " . $text['weekAgo'];
    } elseif ($daysDifference <= -14 && $daysDifference > -21) {
        return "2" . $text['weeksAgo'];
    } elseif ($daysDifference <= -21 && $daysDifference > -28) {
        return "3" . $text['weeksAgo'];
    } elseif ($daysDifference <= -28 && $daysDifference > -35) {
        return "4" . $text['weeksAgo'];
    } elseif ($monthsDifference === -1) {
        return "1 " . $text['monthAgo'];
    } elseif ($monthsDifference < -1 && $monthsDifference >= -11) {
        return abs($monthsDifference) . " " . $text['monthsAgo'];
    } elseif ($yearsDifference === -1) {
        return "1 " . $text['yearAgo'];
    } else {
        return abs($yearsDifference) . " " . $text['yearsAgo'];
    }
}

// نمونه استفاده
//echo convertDateToRelativeTime('2023-12-03', 'fa'); // فارسی
//echo convertDateToRelativeTime('2023-12-03', 'en'); // انگلیسی

?>